<?php
/**
 * Merlin WP configuration file.
 *
 * @package @@pkg.name
 * @version @@pkg.version
 * @author  @@pkg.author
 * @license @@pkg.license
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and other settings for Merlin WP.
 */
$wizard = new Merlin(
	// Configure Merlin with custom settings.
	$config = array(
		'directory'			=> 'framework/inc',						// Location where the 'merlin' directory is placed.
		'demo_directory'		=> 'lib/inc/demo/',					// Location where the theme demo files exist.
		'merlin_url'			=> 'theme-setup',					// Customize the page URL where Merlin WP loads.
		'child_action_btn_url'		=> 'https://codex.wordpress.org/Child_Themes',  // The URL for the 'child-action-link'.
		'help_mode'			=> false,					// Set to true to turn on the little wizard helper.
		'dev_mode'			=> true,					// Set to true if you're testing or developing.
		'branding'			=> false,					// Set to false to remove Merlin WP's branding.
	),
	// Text strings.
	$strings = array(
		'admin-menu' 			=> esc_html__( 'Theme Setup' , 'kleo_framework' ),
		'title%s%s%s%s' 		=> esc_html__( '%s%s Themes &lsaquo; Theme Setup: %s%s' , 'kleo_framework' ),

		'return-to-dashboard' 		=> esc_html__( 'Return to the dashboard' , 'kleo_framework' ),

		'btn-skip' 			=> esc_html__( 'Skip' , 'kleo_framework' ),
		'btn-next' 			=> esc_html__( 'Next' , 'kleo_framework' ),
		'btn-start' 			=> esc_html__( 'Start' , 'kleo_framework' ),
		'btn-no' 			=> esc_html__( 'Cancel' , 'kleo_framework' ),
		'btn-plugins-install' 		=> esc_html__( 'Install' , 'kleo_framework' ),
		'btn-child-install' 		=> esc_html__( 'Install' , 'kleo_framework' ),
		'btn-content-install' 		=> esc_html__( 'Install' , 'kleo_framework' ),
		'btn-import' 			=> esc_html__( 'Import' , 'kleo_framework' ),
		'btn-license-activate' 		=> esc_html__( 'Activate' , 'kleo_framework' ),

		'welcome-header%s' 		=> esc_html__( 'Welcome to %s' , 'kleo_framework' ),
		'welcome-header-success%s' 	=> esc_html__( 'Hi. Welcome back' , 'kleo_framework' ),
		'welcome%s' 			=> esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.' , 'kleo_framework' ),
		'welcome-success%s' 		=> esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.' , 'kleo_framework' ),

		'child-header' 			=> esc_html__( 'Install Child Theme' , 'kleo_framework' ),
		'child-header-success' 		=> esc_html__( 'You\'re good to go!' , 'kleo_framework' ),
		'child' 			=> esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.' , 'kleo_framework' ),
		'child-success%s' 		=> esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.' , 'kleo_framework' ),
		'child-action-link' 		=> esc_html__( 'Learn about child themes' , 'kleo_framework' ),
		'child-json-success%s' 		=> esc_html__( 'Awesome. Your child theme has already been installed and is now activated.' , 'kleo_framework' ),
		'child-json-already%s' 		=> esc_html__( 'Awesome. Your child theme has been created and is now activated.' , 'kleo_framework' ),

		'plugins-header' 		=> esc_html__( 'Install Plugins' , 'kleo_framework' ),
		'plugins-header-success' 	=> esc_html__( 'You\'re up to speed!' , 'kleo_framework' ),
		'plugins' 			=> esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.' , 'kleo_framework' ),
		'plugins-success%s' 		=> esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.' , 'kleo_framework' ),
		'plugins-action-link' 		=> esc_html__( 'Advanced' , 'kleo_framework' ),

		'import-header' 		=> esc_html__( 'Import Content' , 'kleo_framework' ),
		'import' 			=> esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.' , 'kleo_framework' ),
		'import-action-link' 		=> esc_html__( 'Advanced' , 'kleo_framework' ),

		'license-header%s' 		=> esc_html__( 'Activate %s' , 'kleo_framework' ),
		'license' 			=> esc_html__( 'Add your license key to activate one-click updates and theme support.' , 'kleo_framework' ),
		'license-action-link' 		=> esc_html__( 'More info' , 'kleo_framework' ),

		'license-link-1'            	=> wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'license-link-2'            	=> wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://themebeans.com/contact/', esc_html__( 'Get Theme Support', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'license-link-3'           	=> wp_kses( sprintf( '<a href="'.admin_url( 'customize.php' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),

		'ready-header' 			=> esc_html__( 'All done. Have fun!' , 'kleo_framework' ),
		'ready%s' 			=> esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.' , 'kleo_framework' ),
		'ready-action-link' 		=> esc_html__( 'Extras' , 'kleo_framework' ),
		'ready-big-button' 		=> esc_html__( 'View your website' , 'kleo_framework' ),

		'ready-link-1'            	=> wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-2'            	=> wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://seventhqueen.com/support/', esc_html__( 'Get Theme Support', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-3'           	=> wp_kses( sprintf( '<a href="'.admin_url( 'admin.php?page=sweetdate_options' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'kleo_framework' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
	)
);


function merlin_bp_add_custom_fields() {
	bp_add_custom_fields( false );
}