<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ElementorMembersCarousel extends Widget_Base {
	
	public function get_name() {
		return 'members-carousel';
	}
	public function get_title() {
		return __( 'Members Carousel', 'kleo_framework' );
	}
	public function get_icon() {
		return 'eicon-slideshow';
	}
	
	public function get_categories() {
		return [ 'sweetdate-elements' ];
	}
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_members_carousel',
			[
				'label' => __( 'Settings', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'type',
			[
				'label' => __( 'Type', 'kleo_framework' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'newest',
				'options' => [
					'newest' => __( 'Newest', 'kleo_framework' ),
					'active' => __( 'Most Active', 'kleo_framework' ),
					'popular' => __( 'Most Popular', 'kleo_framework' ),
				]
			]
		);
		
		$this->add_control(
			'total',
			[
				'label' => __( 'Total', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '12', 'kleo_framework' ),
				'placeholder' => __( 'Total members', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'width',
			[
				'label' => __( 'Image width', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '94', 'kleo_framework' ),
				'placeholder' => __( 'Pixels', 'kleo_framework' ),
			]
		);
		
		$this->end_controls_section();
	
	}
	protected function render() {
		$settings = $this->get_settings();
		
		$shortcode = sprintf('[kleo_members_carousel type="%s" total="%s" width="%s"]', $settings['type'], $settings['total'], $settings['width'] );
		echo do_shortcode( $shortcode );
		if ( Plugin::$instance->editor->is_edit_mode() ) {
			echo '<script>profilesCarousel();</script>';
		}
	}
	/*protected function _content_template() {
		$this->render();
	}*/
	
}
