<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ElementorPostsCarousel extends Widget_Base {
	
	public function get_name() {
		return 'posts-carousel';
	}
	public function get_title() {
		return __( 'Posts Carousel', 'kleo_framework' );
	}
	public function get_icon() {
		return 'eicon-slideshow';
	}
	
	public function get_categories() {
		return [ 'sweetdate-elements' ];
	}
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_posts_carousel',
			[
				'label' => __( 'Settings', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'cat',
			[
				'label' => __( 'Categories', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '', 'kleo_framework' ),
				'placeholder' => __( 'Comma separated categories names', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'limit',
			[
				'label' => __( 'Limit', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '9', 'kleo_framework' ),
				'placeholder' => __( 'Number of posts', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'post_types',
			[
				'label' => __( 'Post types', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'post', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'post_formats',
			[
				'label'   => __( 'Post formats', 'kleo_framework' ),
				'type'    => Controls_Manager::SELECT2,
				'multiple' => 'true',
				'options' => [
					'image'  => __( 'Image', 'kleo_framework' ),
					'gallery' => __( 'Gallery', 'kleo_framework' ),
					'video'  => __( 'Video', 'kleo_framework' ),
					'audio'  => __( 'Audio', 'kleo_framework' ),
				]
			]
		);
		
		$this->end_controls_section();
	
	}
	protected function render() {
		$settings = $this->get_settings();
		
		$post_formats = 'all';
		if ( ! empty( $settings['post_formats'] ) ) {
			$post_formats = implode( ',', $settings['post_formats'] );
		}
		
		$shortcode = sprintf('[kleo_posts_carousel cat="%s" limit="%s" post_types="%s" post_formats="%s"]', $settings['cat'], $settings['limit'], $settings['post_types'], $post_formats );
		echo do_shortcode( $shortcode );
		if ( Plugin::$instance->editor->is_edit_mode() ) {
			echo '<script>storiesCarousel();</script>';
		}
	}
	
}
