<!-- step 3 -->
<?php
if (!empty($_GET[ 'id' ])) {
	$info = Canvas::get_option( 'welcome-time' );
	$id = $info['id'];

	$reschedule_link = "https://mobiloud.appointlet.com/booking/{$id}/reschedule";
	$datetime = DateTime::createFromFormat('Y-m-d\TH:i:s+', $info[ 'time' ]);
	if ($datetime && class_exists( 'DateTimeZone' )) {
		$timezone = $info[ 'timezone' ];
		$timezone_value = new DateTimeZone($timezone);
		$offset   = $timezone_value->getOffset(new DateTime);

		$time = $datetime->getTimestamp() + $offset;
		$date = date(get_option( 'date_format' ), $time) . ' at ' . date(get_option( 'time_format' ), $time);
	} }
?>

<div class="ml2-block ml2-welcome-block">
	<div class="ml2-body">
		<h3 class="text-center title_big">Your call has been scheduled!</h3>
		<br>
		<p class="text-center">Wee look forward to speaking with you to better understand what your needs are and how our platform can help.
			You can ask any questions you might have during the call, but feel free to email us beforehand: <a href="mailto:support@mobiloud.com">support@mobiloud.com</a>.</p>
		<?php if (!empty($_GET[ 'id' ]) && $datetime) : ?>

			<div class="ml-scheedule-time-block">
				<p>Your call is scheduled for <?php echo "$date $timezone"; ?></p>
			</div>
			<p class="text-center">Need to reschedule? <a href="<?php echo esc_attr($reschedule_link); ?>">Click here</a></p>
		<?php ELSE: ?>
			<div class="ml-scheedule-time-block">
				<p>Your call is scheduled. Check your email for call times and to reschedule. We'll send a reminder prior to the call.</p>
			</div>
		<?php ENDIF; ?>
	</div>
</div>

