<?php
/**
 * BuddyPress - Groups Loop
 *
 * Querystring is set via AJAX in _inc/ajax.php - bp_legacy_theme_object_filter().
 *
 * @package BuddyPress
 * @subpackage bp-legacy
 */

?>

<?php

/**
 * Fires before the display of groups from the groups loop.
 *
 * @since 1.2.0
 */
do_action( 'bp_before_groups_loop' ); ?>

<?php if ( bp_get_current_group_directory_type() ) : ?>
	<p class="current-group-type"><?php bp_current_group_directory_type_message() ?></p>
<?php endif; ?>

<?php if ( bp_has_groups( bp_ajax_querystring( 'groups' ) . "&per_page=" .  apply_filters('kleo_bp_groups_pp', 12 ) ) ) : ?>

	<?php

	/**
	 * Fires before the listing of the groups list.
	 *
	 * @since 1.1.0
	 */
	do_action( 'bp_before_directory_groups_list' ); ?>

	<div id="groups-list" class="item-list search-list" aria-live="assertive" aria-atomic="true" aria-relevant="all">

	<?php while ( bp_groups() ) : bp_the_group(); ?>

		<div <?php bp_group_class(array('four', 'columns')); ?>>
			<div class="search-item">
				<?php if ( ! bp_disable_group_avatar_uploads() ) : ?>
					<div class="avatar">
						<a href="<?php bp_group_permalink(); ?>"><?php bp_group_avatar( 'type=thumb&width=94&height=94&class=' ); ?></a>
					</div>
				<?php endif; ?>
	
				<div class="search-meta">
					<h5 class="author"><a href="<?php bp_group_permalink(); ?>"><?php bp_group_name(); ?></a></h5>
					<p class="date"><span class="activity" data-livestamp="<?php bp_core_iso8601_date( bp_get_group_last_active( 0, array( 'relative' => false ) ) ); ?>"><?php printf( __( 'active %s', 'buddypress' ), bp_get_group_last_active() ); ?></span></p>
	
				</div>
				<div class="search-body">
					<div class="item-desc"><?php bp_group_description_excerpt(); ?></div>
	
					<?php
	
					/**
					 * Fires inside the listing of an individual group listing item.
					 *
					 * @since 1.1.0
					 */
					do_action( 'bp_directory_groups_item' ); ?>
	
				</div>
				<br>
				<div class="action">
					
					<?php
					
					/**
					 * Fires inside the action section of an individual group listing item.
					 *
					 * @since 1.1.0
					 */
					do_action( 'bp_directory_groups_actions' ); ?>
	
					<div class="meta">
						
						<?php bp_group_type(); ?> / <?php bp_group_member_count(); ?>
	
					</div>
	
				</div>
				<br>
				<div class="clear"></div>
			</div>
		</div>

	<?php endwhile; ?>

	</div>

	<?php

	/**
	 * Fires after the listing of the groups list.
	 *
	 * @since 1.1.0
	 */
	do_action( 'bp_after_directory_groups_list' ); ?>

	<div id="pag-bottom" class="pagination">

		<div class="pag-count" id="group-dir-count-bottom">

			<?php bp_groups_pagination_count(); ?>

		</div>

		<div class="pagination-links" id="group-dir-pag-bottom">

			<?php bp_groups_pagination_links(); ?>

		</div>

	</div>

<?php else: ?>

	<div id="message" class="alert-box">
		<?php _e( 'There were no groups found.', 'buddypress' ); ?>
	</div>

<?php endif; ?>

<?php

/**
 * Fires after the display of groups from the groups loop.
 *
 * @since 1.2.0
 */
do_action( 'bp_after_groups_loop' );
