<?php

/*
 * BP Profile Search - form template 'bps-form-legacy'
 *
 * See http://dontdream.it/bp-profile-search/form-templates/ if you wish to modify this template or develop a new one.
 *
 */

	$F = bps_escaped_form_data ();

	$toggle_id = 'bps_toggle'. $F->id;
	$form_id = 'bps_'. $F->location. $F->id;

	if ($F->location != 'directory')
	{
		echo "<div id='buddypress'>";
	}
	else
	{
?>
	<div class="item-list-tabs bps_header" style="clear: both;">
	  <ul>
		<li><?php echo $F->header; ?></li>
<?php
		if ($F->toggle)
		{
?>
		<li class="last">
		  <input id="<?php echo $toggle_id; ?>" type="submit" value="<?php echo $F->toggle_text; ?>">
		</li>
		<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('#<?php echo $form_id; ?>').hide();
				$('#<?php echo $toggle_id; ?>').click(function(){
					$('#<?php echo $form_id; ?>').toggle('slow');
				});
			});
		</script>
<?php
		}
?>
	  </ul>
	</div>
<?php
	}

	echo "<form action='$F->action' method='$F->method' id='$form_id' class='" . apply_filters( 'bp_search_extra_class', 'custom') . " form-search'>\n";

	$j = 0;
	foreach ( $F->fields as $f )
	{
		if ($f->display == 'hidden')  {
			echo "<input type='hidden' name='$f->code' value='$f->value'>\n";
			continue;
		}

		$name = sanitize_title ($f->name);
		$alt = ($j++ % 2)? 'alt': '';
		$class = "editfield $f->code field_$name $alt row";

		echo "<div class='$class'>\n";

		switch ( $f->display ) {
		case 'range':
			if ( $f->type == 'datebox' ) {
				
				$from = ( $f->min == '' ) ? sq_option( 'buddypress_age_start', 18 ): $f->min;
				$to = ( $f->max == '' ) ? sq_option( 'buddypress_age_end', 75 ): $f->max;
				
				echo '<div class="five mobile-one columns">' .
							"<label class='right inline'>" . $f->label ."</label>" .
						'</div>';
				
				echo '<div class="three mobile-one columns">
                    <select name="' . $f->code . '_min" class="expand customDropdown">';
				echo apply_filters( 'kleo_bp_searchform_before_all_li', '<option value=""> </option>' );
				for( $i = sq_option('buddypress_age_start', 18); $i <= sq_option( 'buddypress_age_end', 75 ); $i++ ) {
					echo '<option value="'.$i.'" ' . get_selected( $f->code . '_min', $i, $from ).' >' . $i . '</option>';
				}
				echo '</select>
                  </div>
                  <div class="one mobile-one columns text-center">
                    <label class="inline"> - </label>
                  </div>';
				echo '<div class="three mobile-one columns">
                    <select name="' . $f->code . '_max" class="expand customDropdown">';
				echo apply_filters('kleo_bp_searchform_before_all_li','<option value=""> </option>');
				for( $i = sq_option('buddypress_age_start', 18 ); $i <= sq_option( 'buddypress_age_end', 75 ); $i++ ) {
					echo '<option value="'.$i.'" '. get_selected( $f->code . '_max', $i, $to).' >' . $i . '</option>';
				}
				echo ' </select>
                  </div>';
			} else {
				echo '<div class="five mobile-one columns">';
				echo "<label class='right inline'>".__( $f->label, 'kleo_framework')."</label>";
				echo '</div>';
				echo '<div class="three mobile-one columns">
                  <input type="text" name="' . $f->code . '_min" value="' . $f->min . '" >
                  </div>
                  <div class="one mobile-one columns text-center">
                    <label class="inline"> - </label>
                  </div>';
				echo '<div class="three mobile-one columns">
                      <input type="text" name="' . $f->code . '_max" value="' . $f->max . '" >
                  </div>';
			}
			break;

		case 'textarea':
			echo "<div class='five mobile-four columns'>" .
			     "<label class='right inline' for='$f->code'>" . __( $f->label, 'kleo_framework' ) . "</label>" .
			     "</div>";
			echo "<div class='seven mobile-four columns kleo-textarea'>" .
			     "<input type='text' name='$f->code' id='$f->code' value='$f->value' />" .
			     "</div>";
			break;

		case 'selectbox':
			
			echo "<div class='five mobile-four columns'>" .
			     "<label class='right inline' for='$f->code'>" . __( $f->label, 'kleo_framework' ) . "</label>" .
			     "</div>";
			echo "<div class='seven mobile-four columns kleo-selectbox'>" .
			     "<select class='expand' name='$f->code' id='$f->code'>";
			echo "<option value=''> </option>";
			foreach ( $f->options as $key => $label ) {
				$selected = in_array ( $key, $f->values ) ? "selected='selected'" : "";
				echo "<option $selected value='$key'>" . __( $label, 'kleo_framework' ) . "</option>";
			}
			echo "</select></div>";
			break;

		case 'multiselectbox':
			
			echo "<div class='five mobile-four columns'>" .
			     "<label class='right inline' for='$f->code'>".__( $f->label, 'kleo_framework' )."</label>" .
			     "</div>";
			echo "<div class='seven mobile-four columns kleo-multiselectbox'>" .
			     "<select " . apply_filters('kleo_bp_search_multiselect_attributes', "multiple='multiple' data-customforms='disabled'" )." class='expand' name='{$f->code}[]' id='$f->code'>";
			foreach ( $f->options as $key => $label ) {
				$selected = in_array ($key, $f->values)? "selected='selected'": "";
				echo "<option $selected value='$key'>"  . __($label,'kleo_framework') . "</option>";
			}
			echo "</select></div>";
			break;

		case 'radio':
			
			echo "<div class='five mobile-four columns'>" .
			     "<label class='right'>" . __( $f->label, 'kleo_framework' ) . "<br>";
			echo "<a class='clear-value-" . $f->code . "' href='#'>" .
			        "<small class='kleo-clear-radio'><i class='icon icon-remove'></i> ". __('Clear', 'kleo_framework'). "</small>" .
			     "</a>";
			?>
			<script type="text/javascript">jQuery('.clear-value-<?php echo $f->code; ?>').click(function() {jQuery('input[name=<?php echo $f->code;?>]').attr('checked', false); jQuery('.field_<?php echo $f->code;?> .custom.radio').removeClass('checked');return false; });</script>
			<?php
			echo "</label></div>";
			echo "<div class='seven mobile-four columns kleo-radio field_" . $f->code . "'>";
			
			foreach ( $f->options as $key => $label ) {
				$checked = in_array ($key, $f->values)? "checked='checked'": "";
				echo "<label><input $checked type='radio' name='$f->code' value='$key'> " . __( $label, 'kleo_framework' ) . "</label>";
			}
			echo '</div>';
			break;

		case 'checkbox':
			
			echo "<div class='five mobile-four columns'>" .
			        "<label class='right'>".__( $f->label, 'kleo_framework' )."</label>" .
			     "</div>";
			echo "<div class='seven mobile-four columns kleo-checkbox'>";
			
			foreach ( $f->options as $key => $label ) {
				$checked = in_array ( $key, $f->values ) ? "checked='checked'" : "";
				echo "<label><input $checked type='checkbox' name='{$f->code}[]' value='$key'> " . __( $label, 'kleo_framework') . "</label>";
			}
			echo '</div>';
			
			break;
			
			case 'number':
				echo "<div class='two columns hz-textbox'>" .
				     "<input type='number' name='$f->code' id='$f->code' value='$f->value' placeholder='".__( $f->label, 'kleo_framework')."' />" .
				     "</div>";
				break;
			
			case 'url':
				echo "<div class='two columns hz-textbox'>" .
				     "<input type='number' inputmode='url' name='$f->code' id='$f->code' value='$f->value' placeholder='".__( $f->label, 'kleo_framework')."' />" .
				     "</div>";
				break;
				
			case 'textbox':
			default:
			
			echo "<div class='five mobile-four columns'>" .
			     "<label class='right inline' for='$f->code'>" . __( $f->label,'kleo_framework') . "</label>" .
			     "</div>";
			echo "<div class='seven mobile-four columns kleo-text'>" .
			     "<input type='text' name='$f->code' id='$f->code' value='$f->value' />" .
			     "</div>";
			break;
		}
		
		if ( ! empty ( $f->description ) && $f->description != '-' ) {
			echo "<div class='seven mobile-four columns kleo-text'>";
				echo "<label class='inline'>$f->description</label>\n";
			echo "</div>";
			}
	  



		echo "</div>\n";
	}

	echo "<div class='submit'>\n";
	?>
	<div class="row">
		<div class="seven offset-by-five columns">
			<button type="submit" class="button radius"><i class="icon-search"></i> &nbsp;<?php _e("SEARCH", 'kleo_framework'); ?></button>
		</div>
	</div>
	<span class="notch"></span>
	<?php
	echo "</div>\n";
	echo "</form>\n";

	if ( $F->location != 'directory' )  echo "</div>\n";

// BP Profile Search - end of template
