<?php
if (!defined( 'CANVAS_DIR' )) {
	die();
}
class CanvasViews {

	static private $intercom_init = false;

	static public function view($template, $options = array()) {
		$dir = dirname(dirname(__FILE__)) . '/views/';
		$prefix = (isset($options[ 'welcome' ])) ? 'welcome_' : '';

		$filename = $dir . $prefix . $template . '.php';
		if (file_exists($filename)) {
			if (!empty($options)) {
				extract($options);
			}
			require_once($dir . '/' . $prefix . 'header.php' );
			require_once($filename);
			require_once($dir . '/' . $prefix . 'footer.php' );
		}
	}

	public static function on_admin_head() {
		self::init_intercom();
	}

	/**
	* Init intercom
	*
	*/
	static private function init_intercom() {
		global $current_user;
		if ( is_admin() && current_user_can( 'administrator' ) && CanvasAdmin::using_canvas() && Canvas::get_option( 'init_email' )) {
			$user_email    = Canvas::get_option( 'init_email', $current_user->user_email );
			$user_name     = Canvas::get_option( 'init_name', '' );
			$user_site     = get_option( 'init_site', get_site_url() );
			$theme = wp_get_theme();
			$theme_name = $theme->Name;
			$theme_path = get_stylesheet_directory_uri();
?>
			<script id="IntercomSettingsScriptTag">
				window.intercomSettings = {
					email: "<?php echo esc_js( $user_email ); ?>",
					name: "<?php echo esc_js( $user_name ); ?>",
					site: "<?php echo esc_js( $user_site ); ?>",
					installurl: "<?php echo get_site_url(); ?>",
					sitename: "<?php echo get_bloginfo( 'name' ); ?>",
					push_id: "<?php echo (Canvas::get_option( 'push_app_id' , '' )); ?>",
					version: "<?php echo CANVAS_PLUGIN_VERSION;?>",
					post_count: "<?php echo wp_count_posts()->publish; ?>",
					app_id: "h89uu5zu",
					user_id: "<?php echo esc_js( $user_email ); ?>",
					user_hash: "<?php echo hash_hmac( "sha256", $user_email, "2d8ReoNHhovD4NhWCb72DgrghadvKVwGJsR0t6YR" ); ?>",
					haswoocommerce:<?php echo( is_plugin_active( 'woocommerce/woocommerce.php' ) || class_exists( 'Woocommerce' ) ? '"yes"' : '"no"' ); ?>,
					hasbuddypress:<?php echo( is_plugin_active( 'buddypress/bp-loader.php' ) || class_exists( 'BuddyPress' ) ? '"yes"' : '"no"' ); ?>,
					theme_name: "<?php echo esc_js( $theme_name ); ?>",
					theme_path: "<?php echo esc_js( $theme_path ); ?>",
					canvas: 'yes',
				};
			</script>
			<script>(function () {
				var w = window;
				var ic = w.Intercom;
				if (typeof ic === "function") {
					ic('reattach_activator');
					ic('update', intercomSettings);
				} else {
					var d = document;
					var i = function () {
						i.c(arguments)
					};
					i.q = [];
					i.c = function (args) {
						i.q.push(args)
					};
					w.Intercom = i;
					function l() {
						var s = d.createElement('script');
						s.type = 'text/javascript';
						s.async = true;
						s.src = 'https://widget.intercom.io/widget/h89uu5zu';
						var x = d.getElementsByTagName('script')[0];
						x.parentNode.insertBefore(s, x);
					}

					if (w.attachEvent) {
						w.attachEvent('onload', l);
					} else {
						w.addEventListener('load', l, false);
					}
				}
			})()</script>
			<?php
			self::$intercom_init = true;
		}
	}


	static public function track_intercom($action, $loadInit = false) {
		if ( is_admin() && current_user_can( 'administrator' ) && Canvas::get_option( 'init_email' )) {
			if ( $loadInit || !self::$intercom_init) {
				self::init_intercom();
			}
			?>
			<script type="text/javascript">
				Intercom("trackUserEvent", "<?php echo esc_js('Canvas ' . $action); ?>");
			</script>
			<?php
		}
	}



	public static function add_schedule_demo() {
		if (!Canvas::push_keys_set() && !Canvas::get_option( 'activated' )) {
			$url = !Canvas::get_option('init_email') && !Canvas::get_option('welcome') || Canvas::get_option('init_email') && Canvas::get_option('welcome') ? admin_url( 'admin.php?page=canvas' ) : 'https://www.mobiloud.com/demo/?utm_source=canvas-plugin&utm_medium=admin-demo-notice';
			?>
			<div class="notice is-dismissible canvas-schedule-demo-block0">
				<div class="clear"></div>
				<div id="canvas_img_div0"><img src="<?php echo CANVAS_URL . 'assets/img/icon.png'; ?>"></div>
				<div id="canvas_text_div0">
					<p>Talk to an app expert</p>
					<p>You can get a demo in 5 minutes, but publishing your app is not a quick decision. Take time to talk to one of our experts.</p>
				</div>
				<div id="canvas_btn_div0">
					<a href="<?php echo esc_attr($url); ?>" class="button button-primary canvas-schedule-demo-btn">Schedule a Demo</a>
				</div>
				<div class="clear"></div>
			</div>
			<style type="text/css">
				.canvas-schedule-demo-block0 {
					min-height: 100px;
					padding-left: 0px;
					padding-top: 0px;
					padding-bottom: 0px;
					border-left: 0px;
					display: table;
				}
				#canvas_img_div0 {
					width: 100px;
					margin: 0px 20px 0px 0px;
					display: table-cell;
					vertical-align: middle;
				}
				#canvas_img_div0 img{
					display: block;
					width: 100px;
					height: 100px;
					margin: 0px;
					padding: 0px;
					border-image-width: 0px;
				}
				#canvas_text_div0 {
					display: table-cell;
					vertical-align: middle;
					padding: 0px 20px;
				}
				#canvas_text_div0 > p {
					margin: 0px;
				}
				#canvas_text_div0 > p:first-child {
					font-size: large;
				}
				#canvas_btn_div0 {
					margin: 20px 0px 20px 20px;
					min-height: 60px;
					display: table-cell;
					vertical-align: middle;
				}
				#canvas_btn_div0 .canvas-schedule-demo-btn {
					background-color: #55b63b;
					box-shadow: 0 -3px 0 0 #489b32 inset;
					box-sizing: border-box;
					border: none;
					text-shadow: 0 -1px 1px #489b32, 1px 0 1px #489b32, 0 1px 1px #489b32, -1px 0 1px #489b32;
				}
				@media screen and (min-width: 375px) {
					#canvas_btn_div0 .canvas-schedule-demo-btn {
					font-size: 18px;
					height: 50px;
					line-height: 48px;
					padding: 0px 20px;
				}
				}
				@media screen and (max-width: 425px) {
					#canvas_img_div0 {
					display: none;
				}
				.canvas-schedule-demo-block0, #canvas_text_div0, #canvas_btn_div0 {
					display: block;
				}
				#canvas_btn_div0 {
					text-align: center;
				}
				#canvas_text_div0 {
					padding-top: 20px;
				}
				}
				@media screen and (min-width: 1024px) {
					#canvas_text_div0 {
					width: 90%;
				}
				}
			</style>
			<script type="text/javascript">
				(function($){
					$(document).on('ready', function(){
						$('.canvas-schedule-demo-block0 .notice-dismiss').on('click', function(){
							$.post(ajaxurl, { 'action':'canvas_schedule_dismiss', 't':Math.random()});
						})
					})
				})(jQuery)
			</script>
			<?php
		}
	}
}