<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ElementorRecentGroups extends Widget_Base {
	
	public function get_name() {
		return 'recent-groups';
	}
	public function get_title() {
		return __( 'Recent Groups', 'kleo_framework' );
	}
	public function get_icon() {
		return 'eicon-gallery-grid';
	}
	public function get_categories() {
		return [ 'sweetdate-elements' ];
	}
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_recent_groups',
			[
				'label' => __( 'Settings', 'kleo_framework' ),
			]
		);
		
		$this->add_control(
			'max',
			[
				'label' => __( 'Number of groups', 'kleo_framework' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '4', 'kleo_framework' )
			]
		);
		
		$this->end_controls_section();
	
	}
	protected function render() {
		$settings = $this->get_settings();
		
		$shortcode = sprintf('[kleo_recent_groups max="%s"]', $settings['max']);
		echo do_shortcode( $shortcode );
		if ( Plugin::$instance->editor->is_edit_mode() ) {
			echo '<script>circularMembers()</script>';
		}
	}
	
}
