<?php

/*
 * BP Profile Search - form template 'bps-form-horizontal'
 *
 * See http://dontdream.it/bp-profile-search/form-templates/ if you wish to modify this template or develop a new one.
 *
 */

echo '<div id="search-bar">';
echo '<div class="row">';

$F = bps_escaped_form_data();

$toggle_id = 'bps_toggle' . $F->id;
//$form_id   = 'bps_' . $F->location . $F->id;
$form_id   = 'horizontal_search';

if ( $F->location != 'directory' ) {
	echo "<div id='buddypress'>";
} else {
	if ( $F->header && $F->toggle ) {
		?>
		<div class="item-list-tabs bps_header twelve columns" style="clear: both;">
			<ul>
				<li><?php echo $F->header; ?></li>
				<?php
				if ( $F->toggle ) {
					?>
					<li class="last">
						<input class="tiny button radius" id="<?php echo $toggle_id; ?>" type="submit"
						       value="<?php echo $F->toggle_text; ?>">
					</li>
					<script type="text/javascript">
						jQuery(document).ready(function ($) {
							$('#<?php echo $form_id; ?>').hide();
							$('#<?php echo $toggle_id; ?>').click(function () {
								$('#<?php echo $form_id; ?>').toggle('slow');
							});
						});
					</script>
					<?php
				}
				?>
			</ul>
		</div>
		<?php
	}
}

echo "<form action='$F->action' method='$F->method' id='$form_id' class='" . apply_filters( 'bp_search_horiz_extra_class', 'custom' ) . " dir-form twelve columns custom'>\n";

echo '<div class="row">';
$j = 0;
foreach ( $F->fields as $f ) {
	if ( $f->display == 'hidden' ) {
		echo "<input type='hidden' name='$f->code' value='$f->value'>\n";
		continue;
	}
	
	$name  = sanitize_title( $f->name );
	switch ( $f->display ) {
		case 'range':
			if ( $f->type == 'datebox' ) {
				
				$from = ( $f->min == '' ) ? sq_option( 'buddypress_age_start', 18 ) : $f->min;
				$to   = ( $f->max == '' ) ? sq_option( 'buddypress_age_end', 75 ) : $f->max;
				
				echo '<div class="two columns hz-agerange hz-from">';
				echo '<select name="' . $f->code . '_min" class="expand customDropdown">';
				echo '<option value="">' .  __( $f->label, 'kleo_framework' ) . ' ' . __( 'from', 'kleo_framework' ) . '</option>';
				for ( $i = sq_option( 'buddypress_age_start', 18 ); $i <= sq_option( 'buddypress_age_end', 75 ); $i ++ ) {
					echo '<option value="' . $i . '" ' . get_selected( $f->code . '_min', $i, $from ) . ' >' . $i . '</option>';
				}
				echo '</select>
                </div>';
				echo '<div class="two columns hz-agerange hz-to">
                    <select name="' . $f->code . '_max" class="expand customDropdown">';
				echo '<option value="">' .  __( $f->label, 'kleo_framework' ) . ' ' . __( 'to', 'kleo_framework' ) . '</option>';
				for ( $i = sq_option( 'buddypress_age_start', 18 ); $i <= sq_option( 'buddypress_age_end', 75 ); $i ++ ) {
					echo '<option value="' . $i . '" ' . get_selected( $f->code . '_max', $i, $to ) . ' >' . $i . '</option>';
				}
				echo ' </select>
                  </div>';
			} else {
				echo '<div class="two columns hz-numrange hz-from">';
				echo ' <input type="text" name="' . $f->code . '_min" value="' . $f->min . '" placeholder="' . __( $f->label, 'kleo_framework') . ' '.__('from', 'kleo_framework').'">
                </div>';
				echo '<div class="two columns hz-numrange hz-to">
                      <input type="text" name="' . $f->code . '_max" value="' . $f->max . '" placeholder="' . __( $f->label, 'kleo_framework').' '.__('to', 'kleo_framework').'">
                  </div>';
			}
			break;
		
		case 'textarea':
			echo "<div class='two columns hz-textarea'>";
			echo "<input type='text' name='$f->code' id='$f->code' value='$f->value' placeholder='" . __( $f->label, 'kleo_framework') . "' >" .
			     "</div>";
			break;
		
		case 'selectbox':
			
			echo "<div class='two columns hz-select'>";
			echo "<select class='expand' name='$f->code' id='$f->code'>";
			echo "<option value=''>" . __( $f->label, 'kleo_framework') . "</option>";
			foreach ( $f->options as $key => $label ) {
				$selected = in_array( $key, $f->values ) ? "selected='selected'" : "";
				echo "<option $selected value='$key'>" . __( $label, 'kleo_framework' ) . "</option>";
			}
			echo "</select></div>";
			break;
		
		case 'multiselectbox':
			
			echo "<div class='two columns hz-multiselect'>";
			echo "<select " . apply_filters( 'kleo_bp_search_multiselect_attributes', "multiple='multiple' data-customforms='disabled'" ) . " class='expand' name='{$f->code}[]' id='$f->code'>";
			echo "<option value=''>" . __( $f->label, 'kleo_framework') . "</option>";
			foreach ( $f->options as $key => $label ) {
				$selected = in_array( $key, $f->values ) ? "selected='selected'" : "";
				echo "<option $selected value='$key'>" . __( $label, 'kleo_framework' ) . "</option>";
			}
			echo "</select></div>";
			break;
		
		case 'radio':
			
			echo "<div class='two columns hz-radio'>" .
			     "<label>" . __( $f->label, 'kleo_framework' ) . "</label>";
			echo "</div>";
			
			
			$count = count( $f->options );
			$i = 1;
			foreach ( $f->options as $key => $label ) {
				$class = '';
				if ( $count == $i ) {
					$class = ' last';
				}
				$checked = in_array( $key, $f->values ) ? "checked='checked'" : "";
				
				echo "<div class='two columns bglabel" . $class . "'>";
				echo "<label><input $checked type='radio' name='$f->code' value='$key'> " . __( $label, 'kleo_framework' ) . "</label>";
				echo '</div>';
			}
			break;
		
		case 'checkbox':
			
			echo "<div class='two columns hz-checkbox-name'>" .
			     "<label>" . __( $f->label, 'kleo_framework' ) . "</label>" .
			     "</div>";
			
			$count = count( $f->options );
			$i = 1;
			foreach ( $f->options as $key => $label ) {
				$class = '';
				if ( $count == $i ) {
					$class = ' last';
				}
				$checked = in_array( $key, $f->values ) ? "checked='checked'" : "";
				
				echo "<div class='two columns bglabel hz-checkbox" . $class . "'>";
				echo "<label><input $checked type='checkbox' name='{$f->code}[]' value='$key'> " . __( $label, 'kleo_framework' ) . "</label>";
				echo "</div>";
				$i++;
			}
			
			break;
		
		case 'number':
			echo "<div class='two columns hz-textbox'>" .
			     "<input type='number' name='$f->code' id='$f->code' value='$f->value' placeholder='" . __( $f->label, 'kleo_framework' ) . "' />" .
			     "</div>";
			break;
		
		case 'url':
			echo "<div class='two columns hz-textbox'>" .
			     "<input type='number' inputmode='url' name='$f->code' id='$f->code' value='$f->value' placeholder='" . __( $f->label, 'kleo_framework' ) . "' />" .
			     "</div>";
			break;
		
		case 'textbox':
		default:
			
			echo "<div class='two columns hz-textbox'>";
			echo "<input type='text' name='$f->code' id='$f->code' value='$f->value' placeholder='" . __( $f->label, 'kleo_framework' ) . "'>" .
			     "</div>";
			break;
	}
	
	/*if ( ! empty ( $f->description ) && $f->description != '-' ) {
		echo "<div class='seven mobile-four columns kleo-text'>";
		echo "<label class='inline'>$f->description</label>\n";
		echo "</div>";
	}*/

}
?>
	<div class="two columns hz-submit">
		<button class="small button radius"><i class="icon-search"></i></button>
	</div>
</div>

<span class="notch"></span>
<?php

echo "</form>\n";

if ( $F->location != 'directory' ) {
	echo "</div>\n";
}

echo "</div>\n";
echo "</div>\n";

// BP Profile Search - end of template
